/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.contexts.BombExplodeContext;
import com.gjhi.tinkersinnovation.library.entitys.entitys.tinker_bomb.EBomb;
import com.gjhi.tinkersinnovation.library.hooks.TinkersBombHook;
import com.gjhi.tinkersinnovation.register.TinkersInnovationHooks;
import com.gjhi.tinkersinnovation.register.TinkersInnovationToolStats;
import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;

public class BombModifier
extends NoLevelsModifier
implements ProjectileHitModifierHook {
    protected DamageSource BOMB_PIECE = new DamageSource(TConstruct.prefix((String)"tinker_bomb_piece")).m_19382_();

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.PROJECTILE_HIT);
    }

    public int getPriority() {
        return 1;
    }

    private boolean onBombHit(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, @Nullable LivingEntity attacker) {
        if (attacker != null && projectile instanceof EBomb) {
            EBomb bomb = (EBomb)projectile;
            ToolStack tool = BombModifier.getHeldTool((LivingEntity)attacker, (InteractionHand)attacker.m_7655_());
            if (tool != null) {
                float bomb_radius = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)attacker, (FloatToolStat)TinkersInnovationToolStats.BOMB_RADIUS);
                int piece_count = (int)ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)attacker, (FloatToolStat)TinkersInnovationToolStats.PIECE_COUNT);
                float piece_damage = ConditionalStatModifierHook.getModifiedStat((IToolStackView)tool, (LivingEntity)attacker, (FloatToolStat)TinkersInnovationToolStats.PIECE_DAMAGE);
                BombExplodeContext context = new BombExplodeContext(bomb_radius, piece_count, piece_damage, false, Explosion.BlockInteraction.BREAK);
                for (Object mod : modifiers.getModifiers()) {
                    ((TinkersBombHook)mod.getModifier().getHook(TinkersInnovationHooks.TINKER_BOMB)).onTinkersBombExplosion(modifiers, persistentData, (ModifierEntry)mod, bomb, attacker, context);
                }
                bomb_radius = context.getRadius();
                piece_count = context.getPieceCount();
                piece_damage = context.getPieceDamage();
                bomb.f_19853_.m_46518_((Entity)attacker, bomb.m_20185_(), bomb.m_20186_(), bomb.m_20189_(), bomb_radius, context.isFired(), context.getType());
                List<LivingEntity> entities = TinkersInnovationUtils.getLivingEntitiesInRange((Entity)bomb, bomb_radius, false);
                for (ModifierEntry mod : modifiers.getModifiers()) {
                    ((TinkersBombHook)mod.getModifier().getHook(TinkersInnovationHooks.TINKER_BOMB)).afterTinkersBombExplode(modifiers, persistentData, mod, bomb, attacker, entities);
                }
                HashMap<LivingEntity, Integer> hitted = new HashMap<LivingEntity, Integer>();
                TinkersBombHook.pieceHitting(hitted, entities, piece_count);
                for (ModifierEntry modifierEntry : modifiers.getModifiers()) {
                    ((TinkersBombHook)modifierEntry.getModifier().getHook(TinkersInnovationHooks.TINKER_BOMB)).beforeBombPiecesHit(modifiers, persistentData, modifierEntry, bomb, attacker, entities, hitted);
                }
                for (Map.Entry entry : hitted.entrySet()) {
                    for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                        ((LivingEntity)entry.getKey()).f_19802_ = 0;
                        ((LivingEntity)entry.getKey()).m_6469_(this.BOMB_PIECE, piece_damage);
                    }
                    for (ModifierEntry mod : modifiers.getModifiers()) {
                        ((TinkersBombHook)mod.getModifier().getHook(TinkersInnovationHooks.TINKER_BOMB)).afterBombPiecesHit(modifiers, persistentData, mod, bomb, attacker, (LivingEntity)entry.getKey(), (Integer)entry.getValue());
                    }
                }
                bomb.m_146870_();
                return true;
            }
        }
        return false;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        return this.onBombHit(modifiers, persistentData, modifier, projectile, attacker);
    }

    public boolean onProjectileHitBlock(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, BlockHitResult hit, @Nullable LivingEntity attacker) {
        return this.onBombHit(modifiers, persistentData, modifier, projectile, attacker);
    }
}

